/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.appserver;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.util.StringTokenizer;

class VWSimDocIdParser {
    private static Logger logger = Logger.getLogger("filenet.sim.appserver");
    private static String m_className = "VWSimDocIdParser";
    String library = null;
    String id = null;
    String version = null;
    int type = 0;
    int libType = 0;

    private VWSimDocIdParser() {
    }

    public int getType() {
        return this.type;
    }

    public int getLibraryType() {
        return this.libType;
    }

    public String getId() {
        return this.id;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getVersion() {
        return this.version;
    }

    public VWSimDocIdParser(String path) throws VWException {
        logger.info(m_className, "<init>", path);
        StringTokenizer stmp = new StringTokenizer(path, ":");
        String token = null;
        logger.info(m_className, "<init>", "1");
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            logger.info(m_className, "<init>", "token type=" + token);
            try {
                this.type = Integer.parseInt(token);
            }
            catch (Exception e) {
                throw new VWException("VWSIMDocIdParser.init2a", "{0}: Invalid type.", path);
            }
            if (this.type < 0 || this.type > 6) {
                throw new VWException("VWSIMDocIdParser.init2a", "{0}: Invalid type.", path);
            }
        } else {
            throw new VWException("VWSIMDocIdParser.init2c", "{0}: Invalid IDM Item name.", path);
        }
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            logger.info(m_className, "<init>", "token libType=" + token);
            try {
                this.libType = Integer.parseInt(token);
            }
            catch (Exception e) {
                throw new VWException("VWSIMDocIdParser.init2b", "{0}: Invalid library type.", path);
            }
            if (this.libType < 0 || this.libType > 3) {
                throw new VWException("VWSIMDocIdParser.init2a", "{0}: Invalid library type.", path);
            }
        } else {
            throw new VWException("VWSIMDocIdParser.init2d", "{0}: Missing library type.", path);
        }
        if (!stmp.hasMoreTokens()) {
            throw new VWException("VWSIMDocIdParser.init2", "{0}: Missing library name.", path);
        }
        this.library = stmp.nextToken();
        logger.info(m_className, "<init>", "token 1ibrary=" + this.library);
        if (stmp.hasMoreTokens()) {
            this.id = stmp.nextToken();
            logger.info(m_className, "<init>", "token id=" + this.id);
            if (stmp.hasMoreTokens()) {
                this.version = stmp.nextToken();
                logger.info(m_className, "<init>", "token version=" + this.version);
            }
        } else {
            throw new VWException("VWSIMDocIdParser.init2", "{0}: Missing id.", path);
        }
        logger.info(m_className, "<init>", "library=" + this.library + ", id=" + this.id + ", version=" + this.version);
    }
}

